Textarea g_InstrumentLabel;


boolean pointInBox(int px, int py, int x, int y, int w, int h)
{

  if ((px>x)&&(px<x+w)&&(py>y)&&(py<y+h))
  {
    return true;
  }
  else
  {
    return false;
  }

}


void processFrameSelection()
{


  for (int i=0; i<g_iNumFrames/2; i++)
  {
    int iPixelSize = 2;
    int iDrawX = 20 + i * (iPixelSize * (g_iFrameLength + iPixelSize));

    int iFrame;
    Point2D frameSize;
    
    iFrame = i;
    frameSize = g_WavEditor.drawFrame(iFrame, iDrawX, 200, iPixelSize);
    if (iFrame == g_SelectionInfo.getFrame())
    {    
      noFill();
      stroke(53, 53, 243);
      rect(iDrawX-1, 200-1, frameSize.x+2, frameSize.y+2);
    }
    
    iFrame = i+g_iNumFrames/2;
    frameSize = g_WavEditor.drawFrame(iFrame, iDrawX, 240, iPixelSize);
    if (iFrame == g_SelectionInfo.getFrame())
    {    
      noFill();
      stroke(53, 53, 243);
      rect(iDrawX-1, 240-1, frameSize.x+2, frameSize.y+2);
    }
  }

  if (mouseDown())
  {

    for (int i=0; i<g_iNumFrames/2; i++)
    {
      int iPixelSize = 2;
      int iDrawX = 20 + i * (iPixelSize * (g_iFrameLength + iPixelSize));

      Point2D frameSize = g_WavEditor.getFrameSize(iPixelSize);

      if (pointInBox(mouseX,mouseY,iDrawX,200,frameSize.x,frameSize.y))
      {
        g_SelectionInfo.setFrame(i);
      }
      if (pointInBox(mouseX,mouseY,iDrawX,240,frameSize.x,frameSize.y))
      {
        g_SelectionInfo.setFrame( i+g_iNumFrames/2 );
      }
    } 
  } 

}



void displayClipboard()
{
  g_WavEditor.drawFrame(g_FrameClipboard, 430, 20, 4);
}



void initialiseGUI()
{

  g_ControlP5.addButton("Save",1,20,290,50,20).setId(0);
  
  g_ControlP5.addButton("Copy Frame",1,80,290,80,20).setId(1);

  g_ControlP5.addButton("Paste Frame",1,170,290,80,20).setId(2);
  
  g_ControlP5.addTextarea("clipboardlabel", "Frame Clipboard:", 350,20,200,60);
  
  g_ControlP5.addButton("Copy Square",1,350,100,80,20).setId(3);
  g_ControlP5.addButton("Copy Saw",1,440,100,80,20).setId(4);
  
  g_ControlP5.addSlider("Pulse Width",0,100,50,350,130,100,10);
  
  g_ControlP5.addButton("Generate Pulse",1,350,150,80,20).setId(5);
  
  g_InstrumentLabel = g_ControlP5.addTextarea("instrumentlabel", "Current Instrument: 0", 260,293,200,60);
  
  g_ControlP5.addButton(" <",1,530,290,20,20).setId(6);
  g_ControlP5.addButton(" >",1,555,290,20,20).setId(7);

}



void controlEvent(ControlEvent theEvent) 
{
  //println(theEvent.controller().id());

  if (!g_DataManager.loadedData()) return;

  switch(theEvent.controller().id())
  {
  case 0:
    // save
    g_DataManager.saveData("save.sav");
    break;
  case 1:
    // copy frame
    g_FrameClipboard = g_DataManager.getFrame(g_SelectionInfo).getCopy();
    break;
  case 2:
    // paste frame
    g_DataManager.setFrame(g_SelectionInfo, g_FrameClipboard);
    break;
  case 3:
    // copy square
    g_FrameClipboard = g_SquareFrame.getCopy();
    break;
  case 4:
    // copy saw
    g_FrameClipboard = g_SawFrame.getCopy();
    break;
  case 5:
    // generate pulse
    g_DataManager.setFrame(g_SelectionInfo, generatePulseWidth(floor(g_ControlP5.controller("Pulse Width").value())));
    break;
  case 6:
    // previous instrument
    g_DataManager.previousInstrument();
    g_InstrumentLabel.setText("Current Instrument: " + g_SelectionInfo.getInstrument());
    break;
  case 7:
    // next instrument
    g_DataManager.nextInstrument();
    g_InstrumentLabel.setText("Current Instrument: " + g_SelectionInfo.getInstrument());
    break;
  default:
    break;
  }
}

